package cn.com.duiba.live.normal.service.api.dto.oto.audit;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 描述：
 *
 * @author zhouziwu
 * @date 2022-04-21
 */
@Data
public class InterviewAuditRecordDTO implements Serializable {
    /** 审批表主键 tb_audit_record.id */
    private Long id;

    /** 业务id */
    private Long businessId;

    /** 审批状态 {@link cn.com.duiba.live.normal.service.api.enums.oto.audit.AuditStateEnum} */
    private Integer auditState;

    /** 审批类型 {@link cn.com.duiba.live.normal.service.api.enums.oto.audit.AuditTypeEnum} */
    private Integer auditType;

    /** 销售姓名 */
    private String sellerName;

    /** 客户姓名 */
    private String custName;

    /** 面访类型 {@link cn.com.duiba.live.normal.service.api.enums.oto.interview.InterviewTypeEnum} */
    private Integer interviewType;

    /** 异常原因 1.非面对面扫码 2.客户手机号非本人 3.客户无法扫码 */
    private List<Integer> unusualTypes;

    /** 异常情况说明 */
    private String unusualExplain;

    /** 异常凭证图片 */
    private List<String> unusualProofs;

    /** 面访地址 */
    private String interviewAddress;

    /** 提交时间 */
    private Date commitTime;
}
