package cn.com.duiba.live.normal.service.api.remoteservice.activity.time.red;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.activity.time.red.LiveTimeRedOpenRecordDto;
import cn.com.duiba.live.normal.service.api.dto.activity.time.red.LiveTimeRedTaskRecordDto;

import java.util.List;

/**
 * @author zhuenhui
 * @date 2021/06/10 4:27 下午
 * @description 「看直播攒现金」行为记录RPC
 */
@AdvancedFeignClient
public interface RemoteLiveTimeRedApiService {

    /**
     * 异步批量新增「看直播攒现金」红包开启记录
     *
     * @param list 「看直播攒现金」红包开启记录
     */
    void asyncBatchInsertOpenRecord(List<LiveTimeRedOpenRecordDto> list);

    /**
     * 异步批量新增「看直播攒现金」任务完成记录
     *
     * @param list 「看直播攒现金」任务完成记录
     */
    void asyncBatchInsertTaskRecord(List<LiveTimeRedTaskRecordDto> list);

}
