package cn.com.duiba.live.normal.service.api.dto.oto.log;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 客户呼叫记录表
 * @author kjj mybatis generator 
 * @date 2022-01-13
 */
@Data
public class CustCallLogDto implements Serializable {
     
    private static final long serialVersionUID = 1642038051413136L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 客户id
     */
    private Long custId;

    /**
     * 销售id
     */
    private Long sellerId;

    /**
     * 通话记录id
     */
    private String callSheetId;

    /**
     * 通话id
     */
    private String callId;

    /**
     * 呼叫类型包括 : 1普通来电 , 2外呼通话 , 3转接电话 , 4外呼转接
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.call.OtoCustomerCallTypeEnum
     */
    private Integer callType;

    /**
     * 主叫号码
     */
    private String callNumber;

    /**
     * 被叫号码
     */
    private String calledNumber;

    /**
     * 开始呼叫时间
     */
    private Date callBeginTime;

    /**
     * 开始响铃时间
     */
    private Date callRingTime;

    /**
     * 摘机接通时间
     */
    private Date callRecvTime;

    /**
     * 通话结束时间
     */
    private Date callEndTime;

    /**
     * 通话时长（秒）
     */
    private Integer callTimeLength;

    /**
     * 通话记录状态 : 1已接听, 2振铃未接听, 3已留言 , 4黑名单 , 5排队放弃, 6ivr , 7机器人
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.call.OtoCustomerCallStatusEnum
     */
    private Integer callStatus;

    /**
     * 录音文件地址
     */
    private String callRecordUrl;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}