package cn.com.duiba.live.normal.service.api.enums.live;

import java.util.Objects;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2020-08-05 17:05
 */
public enum LiveSpreadLinkTypeEnum {

    COMPANY(1, "公司维度"),

    LIVE(2, "直播维度"),

    CLUE(3, "线索"),

    LIVE_PLAYBACK(4,"直播回放"),

    LIVE_WELFARE(5, "直播福利页"),

    CUSTOM_PATH(6, "自定义页面路径")

    ;

    private Integer code;
    private String desc;

    LiveSpreadLinkTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 根据代码获取枚举
     * @param code
     * @return
     */
    public static LiveSpreadLinkTypeEnum getByCode(Integer code) {
        for (LiveSpreadLinkTypeEnum linkTypeEnum : LiveSpreadLinkTypeEnum.values()) {
            if (Objects.equals(code, linkTypeEnum.getCode())) {
                return linkTypeEnum;
            }
        }
        return null;
    }
}
