package cn.com.duiba.live.normal.service.api.enums.oto.cust.ext;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-06 16:08
 */
@Getter
@AllArgsConstructor
public enum OtoCustWxStatusEnum {
    /**
     * 0,1,2 全部映射新枚举4
     */
    NOT_ADD(0, "未主动发起加微"),
    ADD_NO_REPLY(1, "已主动添加-对方没反应"),
    ADD_REFUSE(2, "已主动添加-对方拒绝"),
    /**
     * 3由原来的"已主动添加-对方已同意"->"上报已添加"
     */
    ADD_AGREE(3, "上报已添加"),
    NOT_ADD_WX(4, "未添加"),
    /**
     * 5,6为新增枚举值
     */
    CHECCK_ADD_WX(5, "检查已添加"),
    WX_NOT_EXIST(6, "微信不存在"),
    ;


    /**
     * 状态
     */
    private final Integer status;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 包含所有枚举的Map
     */
    private static final Map<Integer, String> ALL_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoCustWxStatusEnum::getStatus, OtoCustWxStatusEnum::getDesc, (v1, v2)->v1)));

    /**
     * 根据状态获取描述
     */
    public static String getDescByStatus(Integer status){
        if (status == null) {
            return null;
        }
        return ALL_MAP.get(status);
    }

}
