package cn.com.duiba.live.normal.service.api.param.successagent;

import cn.com.duiba.live.normal.service.api.param.common.PageQuery;
import java.util.Date;
import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 成功案例大款审核表（仅管理后台使用！！！）
 * @author kjj mybatis generator 
 * @date 2021-01-30
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class LiveSuccessAgentVerifyRecordSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16119740603504750L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播id
     */
    private Long liveId;

    /**
     * 代理人id
     */
    private Long agentId;

    /**
     * 直播用户ids
     */
    private List<Long> agentIds;

    /**
     * 发起人
     */
    private String createUser;

    /**
     * 审核状态 0=审核中 1=审核通过 2=审核不通过
     * @see cn.com.duiba.live.normal.service.api.enums.successagent.SuccessAgentVerifyEnum
     */
    private Integer verifyState;

    /**
     * 根据创建时间查询的开始时间
     */
    private Date startDatetime;

    /**
     * 根据创建时间查询的结束时间
     */
    private Date endDatetime;

    /**
     * 审核状态列表
     */
    private List<Integer> verifyStates;
}