package cn.com.duiba.live.normal.service.api.dto.oto.cust;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 客户面访记录表
 * @author kjj mybatis generator 
 * @date 2022-01-11
 */
@Data
public class CustMeetRecordDto implements Serializable {
     
    private static final long serialVersionUID = 16418847205424830L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 销售id, tb_oto_seller.id
     */
    private Long sellerId;

    /**
     * 客户id, tb_oto_customer.id
     */
    private Long custId;

    /**
     * 提交计划书后客户状态 1近期有机会成交 2近期无法成交 3拒绝
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.visit.OtoCustCommitStatusEnum
     */
    private Integer commitCustStatus;

    /**
     * 是否提交养老规划方案 0否 1是
     * @see cn.com.duiba.live.normal.service.api.enums.BooleanEnum
     */
    private Integer commitPlanFlag;

    /**
     * 面访备注
     */
    private String meetRemark;

    /**
     * 跟进客户权重
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.follow.OtoCustFollowWeightEnum
     */
    private Integer followWeight;

    /**
     * 客户价值  1XX代表未接通 2XX中XX代表分数 3XX代表系统高价值
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustValueEnum
     */
    private Integer custValue;

    /**
     * 销售评价类型
     * @see cn.com.duiba.live.normal.service.api.enums.oto.OtoCommentTypeEnum
     */
    private Integer commentType;

    /**
     * 创建时间
     */
    private Date gmtCreate;
}