package cn.com.duiba.live.normal.service.api.param.oto.cust.visit;

import lombok.Data;

import java.io.Serializable;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-14 14:16
 */
@Data
public class CustFeedbackVisitSaveParam implements Serializable {

    private static final long serialVersionUID = -2890421940846677312L;

    /**
     * 客户id
     */
    private Long custId;

    /**
     * 销售id
     */
    private Long sellerId;

    /**
     * 提交计划书后客户状态
     */
    private Integer commitCustStatus;

    /**
     * 是否提交养老规划方案
     */
    private Integer commitPlanFlag;

    /**
     * 参观备注
     */
    private String visitRemark;

    /**
     * 客户价值
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustValueEnum
     */
    private Integer custValue;

    /**
     * 客户权重
     * {@link cn.com.duiba.live.normal.service.api.enums.oto.cust.follow.OtoCustFollowWeightEnum}
     */
    private Integer followWeight;

    /**
     * 销售评价类型
     * @see cn.com.duiba.live.normal.service.api.enums.oto.OtoCommentTypeEnum
     */
    private Integer commentType;

    /**
     * 评价备注
     * @see cn.com.duiba.live.normal.service.api.enums.oto.log.CustCommonLogKeyEnum
     */
    private String commentRemark;
}
