package cn.com.duiba.live.normal.service.api.remoteservice.oto.cust;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.oto.cust.OtoCustFollowCountDto;
import cn.com.duiba.live.normal.service.api.dto.oto.cust.OtoCustomerExtDto;

import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-11 13:51
 */
@AdvancedFeignClient
public interface RemoteOtoCustExtService {

    /**
     * 根据客户id获取客户ext信息
     * @param custId 客户id
     * @return 客户ext信息
     */
    OtoCustomerExtDto findByCustId(Long custId);

    /**
     * 修改客户ext信息
     * @param dto 客户ext信息
     * @return 客户ext信息
     */
    boolean updateByCustId(OtoCustomerExtDto dto);

    /**
     * 根据客户流程组状态统计客户数
     * @param otoSid oto销售id
     * @return 客户统计数
     */
    List<OtoCustFollowCountDto> getCountByCustFlow(Long otoSid);
}
