package cn.com.duiba.live.normal.service.api.dto.live.push;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播推送
 * @author kjj mybatis generator 
 * @date 2020-07-23
 */
@Data
public class LivePushDto implements Serializable {
     
    private static final long serialVersionUID = 15954719209487997L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 推送类型：1-L5开播提醒
     * @see cn.com.duiba.live.normal.service.api.enums.live.push.PushTypeEnum
     */
    private Integer pushType;

    /**
     * 推送状态：0-未推送，1-推送中，2-已推送
     * @see cn.com.duiba.live.normal.service.api.enums.live.push.PushStatusEnum
     */
    private Integer pushStatus;

    /**
     * 期望推送时间
     */
    private Date pushTime;

    /**
     * 完成推送时间
     */
    private Date pushEndTime;

    /**
     * 推送人数
     */
    private Long pushUserNum;

    /**
     * 推送模式
     * {@link cn.com.duiba.live.normal.service.api.enums.push.LivePushModeEnum}
     */
    private Integer pushMode;

    /**
     * 推送文案
     */
    private LivePushContentDto pushContent;
}