package cn.com.duiba.live.normal.service.api.dto.oto.callback;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * OTO销售信息表
 * @author kjj mybatis generator 
 * @date 2022-07-20
 */
@Data
public class ClueCallbackRecordDto implements Serializable {
     
    private static final long serialVersionUID = 16583044000384432L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 客户id tb_oto_customer.id
     */
    private Long custId;

    /**
     * 渠道 0=其他 1=今日头条 2=百度 3=腾讯 4=快手
     */
    private Integer pubChannel;

    /**
     * 回传时机 1实时 2定时
     * @see cn.com.duiba.live.normal.service.api.enums.oto.callback.CLueCallbackTimingEnum
     */
    private Integer callbackTiming;

    /**
     * 回传原因 1空号客户 2长时间未拨通 3拨通x秒以上
     * @see cn.com.duiba.live.normal.service.api.enums.oto.callback.CLueCallbackReasonEnum
     */
    private Integer callbackReason;

    /**
     * 是否为有效线索 0无效 1有效
     * @see cn.com.duiba.live.normal.service.api.enums.BooleanEnum
     */
    private Integer clueValidFlag;

    /**
     * 三方回传链接
     */
    private String callbackUrl;

    /**
     * 回传结果
     */
    private String callbackResult;
}