package cn.com.duiba.live.normal.service.api.enums.kuaidi100;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;

/**
 * 虚拟物流公司编码
 *
 * @author xuzhigang
 * @date 2022/11/8 11:03 上午
 **/
@Getter
@AllArgsConstructor
public enum VirtualExpressCompanyEnum {

    REDEMPTION_CODE("redemption_code", "兑换码"),

    CARD_NUMBER("card_number", "卡号卡密"),

    REDEMPTION_LINK("redemption_link", "兑换链接"),
    ;

    private final String code;

    private final String desc;

    /**
     * 判断物流公司编码是否是虚拟公司
     *
     * @param code 物流公司编码
     * @return true-虚拟公司 false-真实物流公司
     */
    public static boolean isVirtualExpressCom(String code) {
        return Arrays.stream(values()).anyMatch(t -> t.getCode().equals(code));
    }
}
