package cn.com.duiba.live.normal.service.api.enums.live.push;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhi
 * @date 2020/7/23 10:42 AM
 */
@Getter
@AllArgsConstructor
public enum PushStatusEnum {

    //0-未推送，1-推送中，2-已推送
    INIT(-1, "初始化-配置还不完整，不具备推送条件"),
    UN_PUSH(0, "未推送"),
    PUSHING(1, "推送中"),
    PUSHED(2, "已推送"),
    ;

    /**
     * 状态
     */
    private final Integer code;

    /**
     * 描述
     */
    private final String desc;
}
