package cn.com.duiba.live.normal.service.api.remoteservice.oto.cust;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-10-11 13:51
 */
@AdvancedFeignClient
public interface RemoteOtoCustKVService {

    //默认失效时间 2099-01-01 00:00:00
    Date DEFAULT_EXPIRE_DATE = new Date(4070880000000L);

    /**
     * 获取{@code String}类型的值,
     *
     * @param key 键
     * @return 如果值存在且尚未过期，返回对应值；否则返回{@code null}
     */
    String get(Long custId, String key);

    /**
     * 批量获取{@code String}类型的值，如果某个键不存在，将使用{@code null}填充对应位置
     *
     * @param keys 键组成的列表
     * @return 由值组成的{@code List}，一定不会为{@code null}；如果值存在且尚未过期，目标位置为对应值；否则目标位置为{@code null}
     */
    List<String> multiGet(Long custId, List<String> keys);

    /**
     * 批量获取{@code String}类型的值，如果某个键不存在，将使用{@code null}填充value值
     *
     * @param keys 键组成的列表
     * @return 如果value值存在且尚未过期，目标位置为对应值；否则目标位置为{@code null}
     */
    Map<String, String> multiGetNew(Long custId, List<String> keys);


    /**
     * 批量获取{@code String}类型的值，如果某个键不存在，将使用{@code null}填充value值
     *
     * @param keys 键组成的列表
     * @return 如果value值存在且尚未过期，目标位置为对应值；否则目标位置为{@code null}
     */
    Map<Long,Map<String, String>> multiGetCustIds(List<Long> custIds, List<String> keys);

    /**
     * 设置一个键值对，值为{@code String}类型，默认失效时间为 January 1, 2099, 00:00:00 GMT
     * 如果键不存在，则新增一条记录；如果键已经存在，则会修改值，但不会修改失效时间
     *
     * @param key   键
     * @param value 值
     */
    void setString(Long custId, String key, String value) throws BizException;

    /**
     * 设置一个键值对，值为{@code String}类型，默认失效时间为 January 1, 2099, 00:00:00 GMT
     * 如果键不存在，则新增一条记录；如果键已经存在，则会修改值，但不会修改失效时间
     *
     * @param params map
     */
    void setStringMap(Long custId, Map <String,String> params);

    /**
     * 设置一个键值对，值为{@code String}类型，并设置失效时间
     * 如果键不存在，则新增一条记录；如果键已经存在，则会修改值，并且设置失效时间
     *
     * @param key        键
     * @param value      值
     * @param expireTime 失效时间
     */
    void setStringWithExpire(Long custId, String key, String value, Date expireTime) throws BizException;

    /**
     * 设置一个键值对，值为{@code String}类型，默认失效时间为 January 1, 2099, 00:00:00 GMT
     * 只有当键不存在时才会设置成功
     *
     * @param key   键
     * @param value 值
     * @return 设置记录成功时返回 {@code true};否则返回 {@code false}
     */
    boolean setIfAbsentString(Long custId, String key, String value) throws BizException;

    /**
     * 删除键对应的记录
     *
     * @param key 键
     * @return 如果键已存在且有效则返回 {@code true};否则返回 {@code false}
     */
    boolean deleteByKey(Long custId, String key);

    /**
     * 批量删除键对应的记录
     *
     * @param keys 需要删除的键组成的list
     * @return 成功删除的有效记录数
     */
    int deleteByKeys(Long custId, List<String> keys);
}
