package cn.com.duiba.live.statistics.service.api.enums.customer;

import cn.com.duiba.live.statistics.service.api.util.NumberUtil;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 代理人客户基础信息扩展infoName枚举
 *
 * @author ZhangJun
 * @date 2021/6/30 4:04 下午
 */
@Getter
@AllArgsConstructor
public enum AgentCustomerExtEnum {

    /**
     * 性别，null/0:未知，1-男，2-女
     */
    SEX(1, "性别"),

    /**
     * 年龄，null：未知，0：0～10岁，1：11～20岁，以此类推
     */
    AGE(2, "年龄"),

    /**
     * 职业，直接取值
     */
    JOB(3, "职业"),

    /**
     * 年收入，null：未知，0：0～10万，1：1～10万，以此类推
     */
    INCOME(4, "收入"),

    /**
     * 所在地址，直接取值
     */
    LOCATION(5, "地址"),

    /**
     * 爱好，直接取值，英文逗号分隔
     */
    HOBBY(6, "爱好"),

    /**
     * 保险意识强弱，null：未知，0：弱，1：较弱，2：中，3：较强，4：强
     */
    INSURANCE_AWARENESS(7, "保险意识"),

    /**
     * 持保情况，null：未知，0：未持保，1：已持保
     */
    HAS_INSURANCE(8, "持保情况"),
    ;


    /**
     * 扩展字段值
     */
    private final Integer infoName;

    /**
     * 扩展字段含义
     */
    private final String desc;

    private static final Map<Integer, AgentCustomerExtEnum> ENUM_MAP = new HashMap<>();

    static {
        for (AgentCustomerExtEnum item : values()) {
            ENUM_MAP.put(item.getInfoName(), item);
        }
    }

    /**
     * 是否存在该枚举字段
     */
    public static boolean existEnum(Integer infoName) {
        if (NumberUtil.isNullOrLteZero(infoName)) {
            return false;
        }
        AgentCustomerExtEnum item = ENUM_MAP.get(infoName);
        return Objects.nonNull(item);
    }

}
