package cn.com.duiba.live.statistics.service.api.remoteservice.customer;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.statistics.service.api.dto.customer.AgentCustomerExtDto;
import cn.com.duiba.live.statistics.service.api.dto.customer.AgentCustomerInfoDto;
import cn.com.duiba.live.statistics.service.api.param.customer.AgentCustomerListParam;

import java.util.List;

/**
 * 客户维度，代理人客户基础信息
 *
 * @author ZhangJun
 * @date 2021/6/30 3:34 下午
 */
@AdvancedFeignClient
public interface RemoteAgentCustomerApiService {

    /**
     * 根据指定条件分页查询代理人客户列表
     *
     * @param param 查询条件
     * @return 客户列表
     */
    List<AgentCustomerInfoDto> getListByCondition(AgentCustomerListParam param);

    /**
     * 获取代理人客户基础信息
     *
     * @param agentId    代理人id
     * @param customerId 客户id
     * @return 客户基础信息
     */
    AgentCustomerInfoDto getAgentCustomerInfo(Long agentId, Long customerId);

    /**
     * 获取代理人客户扩展信息
     *
     * @param agentId    代理人id
     * @param customerId 客户id
     * @return 客户扩展信息
     */
    List<AgentCustomerExtDto> getAgentCustomerExt(Long agentId, Long customerId);

    /**
     * 备注客户名称
     *
     * @param agentId  代理人id
     * @param customerId  客户id
     * @param remarkName 客户备注
     * @return 备注结果
     */
    boolean remarkCustomerName(Long agentId, Long customerId, String remarkName);

    /**
     * 代理人手动更新客户扩展信息
     *
     * @param agentId    代理人id
     * @param customerId 客户id
     * @param infoName   扩展字段名
     * @param infoValue  扩展字段值
     * @return 更新结果
     */
    boolean updateCustomerExtWithAgent(Long agentId, Long customerId, Integer infoName, String infoValue);

    /**
     * 使用ES自动更新客户扩展信息
     *
     * @param agentId    代理人id
     * @param customerId 客户id
     * @param infoName   扩展字段名
     * @param infoValue  扩展字段值
     * @return 更新结果
     */
    boolean updateCustomerExtWithEs(Long agentId, Long customerId, Integer infoName, String infoValue);

}
