package cn.com.duiba.live.statistics.service.api.remoteservice.round;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.statistics.service.api.dto.round.LiveTimeRedRoundStatDto;
import java.util.List;
import java.util.Map;

/**
 * @author guoxuebiao
 * @date 2021/6/10 5:08 下午
 */
@AdvancedFeignClient
public interface RemoteLiveTimeRedRoundStatApiService {

    /**
     * 保存轮次红包领取情况
     * @param dto 红包统计参数
     * @return 保存成功的个数
     */
    int saveTimeRedRoundStat(LiveTimeRedRoundStatDto dto);

    /**
     * 根据时长红包轮次id查询时长红包轮次统计列表
     * @param redRoundIds 红包轮次id列表
     * @return 时长红包轮次统计列表
     */
    List<LiveTimeRedRoundStatDto> findByRedRoundIds(List<Long> redRoundIds);

    /**
     * 异步批量添加时长轮次红包的领取人数
     * @param receiveNumMap key：时长轮次红包，value：需要添加的领取人数
     */
    void asyncBatchIncrReceiveNum(Map<Long, Integer> receiveNumMap);

}
