package cn.com.duiba.live.statistics.service.api.dto.agent;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播统计-代理人维度统计信息
 * @author kjj mybatis generator 
 * @date 2020-03-28
 */
@Data
public class LiveStatisticsAgentDto implements Serializable {
     
    private static final long serialVersionUID = 15853608937952842L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 直播公司ID
     */
    private Long companyId;

    /**
     * 直播公司下团队ID
     */
    private Long teamId;

    /**
     * 代理人ID
     */
    private Long agentId;

    /**
     * 邀请人数
     */
    private Integer invitationNum;

    /**
     * 高价值线索数
     */
    private Integer valuableNum;

    /**
     * 到场人数
     */
    private Integer presentNum;

    /**
     * 排名
     */
    private Integer ranking;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 线索总数
     */
    private Integer clueNum;

    /**
     * 已读线索数
     */
    private Integer readNum;


    /**
     * 老客户(直接邀请)数
     */
    private Integer oldCustomerNum;

    /**
     * 新客户(间接邀请)数
     */
    private Integer newCustomerNum;
}