package cn.com.duiba.live.statistics.service.api.dto.user;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 访客直播线索得分详情
 * @author kjj mybatis generator 
 * @date 2020-07-24
 */
@Data
public class LiveUserScoreStatDto implements Serializable {
     
    private static final long serialVersionUID = 15955744473143097L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 访客ID
     */
    private Long visitorId;

    /**
     * 访客的代理人ID
     */
    private Long agentId;

    /**
     * 观看时长得分
     */
    private Integer watchScore;

    /**
     * 评论得分
     */
    private Integer speakScore;

    /**
     * 订阅得分
     */
    private Integer subscribeScore;

    /**
     * 关注得分
     */
    private Integer appointScore;

    /**
     * 分享得分
     */
    private Integer shareScore;

    /**
     * 提问得分
     */
    private Integer questionScore;

    /**
     * 投票得分
     */
    private Integer choiceQuestionScore;

    /**
     * 抽奖得分
     */
    private Integer lotteryScore;

    /**
     * 免费领得分
     */
    private Integer freeLotteryScore;

    /**
     * 领取资料得分
     */
    private Integer resourceScore;

    /**
     * 咨询得分
     */
    private Integer adviceScore;

    /**
     * 总分
     */
    private Integer totalScore;

    /**
     * 提交表单得分
     */
    private Integer formScore;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}