package cn.com.duiba.live.statistics.service.api.remoteservice.company;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.statistics.service.api.dto.company.LiveCompanyStatisticsDto;

/**
 * @author 吴文哲
 * @date 2021/1/4 1:38 下午
 **/
@AdvancedFeignClient
public interface RemoteLiveCompanyStatisticsApiService {

    /**
     * 根据主键查询
     * @param companyId 主键
     * @return 直播公司-统计数据
     */
    LiveCompanyStatisticsDto selectByCompanyId(Long companyId);

    /**
     * 新增
     * @param entity 直播公司-统计数据
     * @return 执行结果
     */
    int insert(LiveCompanyStatisticsDto entity);

    /**
     * 关注人数 +1
     * @param companyId 公司Id
     * @return 执行结果
     */
    int increaseSubscribeNum( Long companyId);
}
