package cn.com.duiba.live.statistics.service.api.remoteservice.push;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.statistics.service.api.dto.push.LivePushManagerStatDto;

import java.util.List;

/**
 * @author linjianhui
 * @description 自定义推送数据统计接口
 * @date 2021/1/5 17:09
 */
@AdvancedFeignClient
public interface RemoteLivePushManagerStatService {

    /**
     * 查询自定义推送数据
     * @param pushIds 自定义推送id列表
     * @return
     */
    List<LivePushManagerStatDto> findByPushIds(List<Long> pushIds);

    /**
     * 根据自定义推送id查询
     * @param pushId 自定义推送id
     * @return
     */
    LivePushManagerStatDto findByPushId(Long pushId);
}
