package cn.com.duiba.live.statistics.service.api.remoteservice.user;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.statistics.service.api.dto.user.LiveStatisticsUserDto;
import cn.com.duiba.live.statistics.service.api.dto.user.OutLiveStatisticUserReadDto;
import cn.com.duiba.live.statistics.service.api.param.clue.LiveClueQueryParam;
import cn.com.duiba.live.statistics.service.api.param.user.LiveStatisticClueNumDto;
import cn.com.duiba.live.statistics.service.api.param.user.LiveStatisticsUserSearchParam;

import java.util.List;

/**
 * 直播用户统计
 * @author 吴文哲
 * @date 2021/1/5 3:04 下午
 **/
@AdvancedFeignClient
public interface RemoteLiveStatisticsUserApiService {

    /**
     * 根据条件查询 支持分页
     *
     * @param param
     * @return
     */
    List<LiveStatisticsUserDto> findByCondition(LiveStatisticsUserSearchParam param);

    /**
     * 根据主键自增分享数
     *
     * @param id
     * @return
     */
    Integer increaseShareNum( Long id);

    /**
     * 根据条件查询用户统计列表
     * * 外部api专用
     *
     * @param param
     * @param agentId
     * @return
     */
    List<LiveStatisticsUserDto> findByCondition4OutApi( LiveClueQueryParam param,  Long agentId);

    /**
     * 根据条件查询用户统计列表
     * *      * 外部api专用
     *
     * @param param
     * @param agentId 代理人id
     * @return
     */
    Integer countStatisticUserByCondition4OutApi( LiveClueQueryParam param,Long agentId);

    /**
     * 根据唯一约束查询
     *
     * @param liveId
     * @param agentId
     * @param liveUserId
     * @return
     */
    LiveStatisticsUserDto findByLidAidUid( Long liveId, Long agentId, Long liveUserId);

    /**
     * 查出代理人曾经参加过的直播
     * kjy-web线索中使用
     *
     * @param agentId
     * @return
     */
    List<Long> findAgentLiveRecord(Long agentId);

    /**
     * 根据直播ID查询
     * @param liveId
     * @return
     */
    List<LiveStatisticsUserDto> findByLiveId(Long liveId);

    /**
     * 根据直播id和代理人id集合查询
     * @param liveId 直播id
     * @param agentIds 代理人id集合
     * @return 用户统计数据
     */
    List<LiveStatisticsUserDto> findByLiveIdAndAgentIds( Long liveId,  List<Long> agentIds);


    /**
     * 统计线索数
     * @param agentIds 代理人id列表
     * @param clueLevel 线索等级
     * @return
     */
    List<LiveStatisticClueNumDto> countAgentClueByClueLevel(List<Long> agentIds, Long liveId, Integer clueLevel);

    /**
     * 根据唯一索引查询已读标识信息
     * @param liveId 直播id
     * @param agentId 直播代理人id
     * @param userId 访客直播用户id
     * @return 已读标识信息
     */
    OutLiveStatisticUserReadDto findReadByUnique( Long liveId,  Long agentId,  Long userId);

    /**
     * 根据主键id将线索标记为已读
     * @param id 主键id
     * @return 执行结果
     */
    int readClueById( Long id);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 直播访客数据统计
     */
    LiveStatisticsUserDto selectById(Long id);


    /**
     * 批量更新
     *
     * @param list
     * @return
     */
    Integer batchUpdate( List<LiveStatisticsUserDto> list);

    /**
     * 批量更新
     *
     * @param addList
     * @return
     */
    Integer batchInsert( List<LiveStatisticsUserDto> addList);

    /**
     * 根据直播间id  用户id列表查询
     *
     * @param liveId
     * @param userIds
     * @return
     */
    List<LiveStatisticsUserDto> findByLiveIdAndUserIds(Long liveId,  List<Long> userIds);

    /**
     * 新增
     *
     * @param entity 直播访客数据统计
     * @return 执行结果
     */
    int insert(LiveStatisticsUserDto entity);

    /**
     * 计算代理人线索数
     * @return
     */
    int countAgentClueNum( Long liveId,  Long agentId,Integer clueLevel);

    /**
     * 根据主键id查询列表
     * @param ids 主键id列表
     * @return 直播用户统计数据列表
     */
    List<LiveStatisticsUserDto> findByIds( List<Long> ids);

}
