package cn.com.duiba.live.ws.register.api.remoteservice.message;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.ws.register.api.dto.message.MessageBody;

import java.util.List;
import java.util.Map;

/**
 * websocket定时推送 【通用队列】操作。 包含用户类型【所有用户】【指定用户】 包含类型【插入】
 * !important T: 必须写在live-ws-register
 * @author dugq
 * @date 2020-07-01
 */
@AdvancedFeignClient
public interface RemoteCommonPushService {
    /**
     * 往队列中添加需要推送给全部用户的推送
     * @param liveId 直播ID
     * @param messageList 推送内容。直接传入对象列表
     */
    <T extends MessageBody> void addCommonPushAll(Long liveId, int msgType, List<T> messageList);

    /**
     * 往队列中添加需要推送给指定用户的推送
     * @param liveId 直播ID
     * @param messageList  推送内容。直接传入对象列表
     */
    <T extends MessageBody> void addCommonPushPersonal(Long liveId, Long userId, int msgType, List<T> messageList);

    /**
     * 批量执行加入队列操作，并同时进行限流操作
     * @param liveId 直播ID
     * @param msgType 推送类型
     * @param messageMap key：用户ID，value：通用推送给个人信息
     * @param <T> 消息类型
     */
    <T extends MessageBody> void batchAddCommonPushPersonal(Long liveId, int msgType, Map<Long, List<T>> messageMap);
}
