package cn.com.duiba.live.ws.register.api.dto.message.mq;

import cn.com.duiba.live.ws.register.api.dto.message.WsResultDto;
import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2020/3/24 7:05 PM
 * websocket 批量给指定用户发送消息，走mq的bean
 *
 * @important 需要大批量推送的，请自定义消息队列，走定时拉取。
 *
 * 出于限流考虑，关闭批量操作
 */
@Data
public class WsPersonalResult4MqMsgDto implements Serializable {

    private static final long serialVersionUID = -8198480478383843087L;
    /**
     * 响应数据
     */
    private WsResultDto result;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 直播ID
     */
    private Long liveId;
}
