package cn.com.duiba.mall.center.api.domain.dto.groupbuy;

import java.io.Serializable;
import java.util.Date;

/**
* 拼团订单表
*/
public class GroupBuyOrderDto implements Serializable {

    private static final long serialVersionUID = 3036502567037093173L;
    /**
    * 主键
    */
    private Long id;

    /**
    * app_id
    */
    private Long appId;

    /**
    * 活动id
    */
    private Long actId;

    /**
    * 团id
    */
    private Long groupId;

    /**
    * cid
    */
    private Long consumerId;

    /**
    * 商品id
    */
    private Long appItemId;

    /**
    * skuid
    */
    private Long skuId;

    /**
     * 消耗积分
     */
    private Long actualCredits;
    /**
     * 原积分
     */
    private Long originalCredits;

    /**
     * 消耗钱 单位分
     */
    private Long actualPrice;
    /**
     * 原价 单位分
     */
    private Long originalPrice;

    /**
    * 主订单Id
    */
    private Long orderId;

    /**
    * 订单状态，0待支付 1支付成功，拼团中，10成功，20失败,规定时间内未成团，21失败,开发者失效活动，22失败,团已满,23 未支付'
    */
    private Integer status;

    /**
     * 是否满团
     */
    private Boolean hasFullGroup;

    public Boolean getHasFullGroup() {
        return hasFullGroup;
    }

    public void setHasFullGroup(Boolean hasFullGroup) {
        this.hasFullGroup = hasFullGroup;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setActId(Long actId) {
        this.actId = actId;
    }

    public Long getActId() {
        return actId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getSkuId() {
        return skuId;
    }


    public Long getActualCredits() {
        return actualCredits;
    }

    public void setActualCredits(Long actualCredits) {
        this.actualCredits = actualCredits;
    }

    public Long getOriginalCredits() {
        return originalCredits;
    }

    public void setOriginalCredits(Long originalCredits) {
        this.originalCredits = originalCredits;
    }

    public Long getActualPrice() {
        return actualPrice;
    }

    public void setActualPrice(Long actualPrice) {
        this.actualPrice = actualPrice;
    }

    public Long getOriginalPrice() {
        return originalPrice;
    }

    public void setOriginalPrice(Long originalPrice) {
        this.originalPrice = originalPrice;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getStatus() {
        return status;
    }


    public GroupBuyOrderDto() {
    }

    public GroupBuyOrderDto(Integer status, Boolean hasFullGroup) {
        this.status = status;
        this.hasFullGroup = hasFullGroup;
    }
}

