package cn.com.duiba.mall.center.api.domain.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 此类描述的是：简版后台错误码<br>
 * 错误码组成：AABCCCC
 * <ul>
 * AA：模块编号
 * <li>01：模块共用</li>
 * <li>02：活动模块</li>
 * <li>03：奖品模块</li>
 * <li>04：订单数据模块</li>
 * </ul>
 * <ul>
 * B：内外部错误码标志
 * <li>0：内部错误码</li>
 * <li>1：外部错误码</li>
 * </ul>
 * <ul>
 * <ul>
 * CCCC:具体错误码 举例
 * <li>通用的成功状态码：0000000</li>
 * <li>通用的未知错误码：9999999</li>
 * </ul>
 *
 * @author: zp
 */
public enum ErrorCode {

    /***** 系统级别异常 ******/
    MC000000("0000000", "未知异常"),
    MC000001("0000001", "参数非法"),
    MC000002("0000002", "缺失用户ID"),
    MC000003("0000003", "缺失商品ID"),
    MC000004("0000004", "不支持的状态类型"),

    //拼团错误码
    MC000100("0000100", "活动已失效"),
    MC000101("0000101", "活动已结束"),
    MC000102("0000102", "团已满"),
    ;


    private String code;

    private String desc;

    ErrorCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static Map<String, ErrorCode> map = new HashMap<>();

    static {
        for (ErrorCode each : ErrorCode.values()) {
            map.put(each.getCode(), each);
        }
    }

    public static ErrorCode getErrorCode(String code) {
        ErrorCode error = map.get(code);
        return error != null ? error : MC000000;
    }

    /**
     * errorCode.
     *
     * @return the errorCode
     */
    public String getCode() {
        return code;
    }


    /**
     * desc.
     *
     * @return the desc
     */
    public String getDesc() {
        return desc;
    }


}
