package cn.com.duiba.mall.center.api.domain.enums.seckill;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by HePeng on 2019/03/28 18:09.
 */
public enum SecKillActConfModeEnum {
    MODE_ONCE(0, "单次模式"),
    MODE_CYCLE(1, "每日循环模式"),
    MODE_MONDAY(11, "周一循环模式"),
    MODE_TUESDAY(12, "周二循环模式"),
    MODE_WEDNESDAY(13, "周三循环模式"),
    MODE_THURSDAY(14, "周四循环模式"),
    MODE_FRIDAY(15, "周五循环模式"),
    MODE_SATURDAY(16, "周六循环模式"),
    MODE_SUNDAY(17, "周日循环模式"),
    ;

    private int code;
    private String desc;

    private static final ImmutableMap<Integer, SecKillActConfModeEnum> ALL_MAP;
    static {
        Map<Integer, SecKillActConfModeEnum> temp = Maps.newHashMap();
        for(SecKillActConfModeEnum enumVal: SecKillActConfModeEnum.values()) {
            temp.put(enumVal.getCode(), enumVal);
        }
        ALL_MAP = ImmutableMap.copyOf(temp);
    }

    public static SecKillActConfModeEnum getByCode(Integer code) {
        return ALL_MAP.get(code);
    }

    SecKillActConfModeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
