package cn.com.duiba.mall.center.api.remoteservice.fulcredits;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.mall.center.api.domain.dto.PaginationDto;
import cn.com.duiba.mall.center.api.domain.dto.fulcredits.FulcreditsActConfDto;
import cn.com.duiba.mall.center.api.domain.dto.fulcredits.FulcreditsActItemDto;
import cn.com.duiba.mall.center.api.domain.dto.fulcredits.FulcreditsActOptionsDto;
import cn.com.duiba.mall.center.api.domain.paramquary.fulcredits.FulCreditsActItemQueryListParam;
import cn.com.duiba.mall.center.api.domain.paramquary.fulcredits.FulCreditsActQueryListParam;
import java.util.Date;
import java.util.List;
import java.util.Map;


/**
 * 满赠活动配置
 */
@AdvancedFeignClient
public interface RemoteFulcreditsActConfService {
    /**
     * 活动列表
     * @param param
     * @return
     */
    PaginationDto<FulcreditsActConfDto> getList(FulCreditsActQueryListParam param);

    /**
     * 根据活动id失效活动
     * @param actId
     * @return
     */
    Boolean disableByActId(Long actId);

    /**
     * 根据活动id删除活动
     * @param actId
     * @return
     */
    Boolean deleteByActId(Long actId);

    /**
     * 活动配置及奖励信息，不含满赠商品信息，满赠商品信息通过 getItemForDetail 查
     * 根据活动id查询活动详情
     * @param actId
     * @param isDeleted true-含已删除数据，false-不含已删除数据
     * @return
     */
    FulcreditsActConfDto getDetail(Long actId, Boolean isDeleted);

    /**
     * 只查活动配置，不含奖励与满赠商品信息
     * 这个接口没有查询满赠商品
     * @param actId
     * @return
     */
    FulcreditsActConfDto getSimpleDetail(Long actId);

    /**
     * 查询赠品信息
     * @param actId
     * @return
     */
    List<FulcreditsActOptionsDto> getActOptions(Long actId);

    /**
     * 查询活动详情中的满赠商品
     * @param param
     * @return
     */
    PaginationDto<FulcreditsActItemDto> getItemForDetail(FulCreditsActItemQueryListParam param);

    /**
     * 根据活动id查询活动（有缓存）
     * @param actId
     * @return
     */
    FulcreditsActConfDto getCachedDetail(Long actId);

    /**
     * 校验同一时间段重复活动
     * @param actId
     * @param actStart
     * @param actEnd
     * @return true-无重复活动，false-有重复活动
     */
    Boolean checkDuplicateActTime(Long appId, Long actId, Date actStart, Date actEnd) throws BizException;

    /**
     * 保存活动配置（新增或修改）
     * @param fulcreditsActConfDto
     * @return
     */
    Long saveOrUpdateConf(FulcreditsActConfDto fulcreditsActConfDto) throws BizException;

    /**
     * 修改进行中活动配置
     * @param fulcreditsActConfDto
     * @return
     */
    Integer updateRunningActConf(FulcreditsActConfDto fulcreditsActConfDto) throws BizException;

    /**
     * 返回进行中的商品id及期活动
     *
     * @param appId
     * @return
     */
    List<FulcreditsActConfDto> findRunningActByApp(Long appId);

    /**
     * 根据appId查询 进行中或者未开始的需要指定商品的活动 活动
     * @param appId
     * @return
     */
    List<FulcreditsActConfDto> findCustomEnableActByApp(Long appId);

    FulcreditsActConfDto findRunningActByItemAndApp(Long appItemId, Long appId);

    Map<Long, FulcreditsActConfDto> findRunningActByItemListAndApp(List<Long> appItemIdList, Long appId);

    FulcreditsActItemDto getByActItemId(Long actId, Long appItemId);

    List<FulcreditsActItemDto> getByActItemIdList(Long actId, List<Long> appItemIdList);
    /**
     * 批量保存满赠商品
     * @param actId
     * @return
     */
    Integer batchSaveActItem(Long actId, List<Long> appItemIds) throws BizException;

    /**
     * 删除满赠商品
     * @param actId
     * @param appItemId
     * @return
     */
    Integer deleteActItem(Long actId, Long appItemId) throws BizException;

    /**
     * 已选中满赠商品ids
     * @param actId
     * @return
     */
    List<Long> selectedActItemIdsByActId(Long actId) throws BizException;
}
