package cn.com.duiba.mall.center.api.remoteservice.seckill;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.mall.center.api.domain.dto.PaginationDto;
import cn.com.duiba.mall.center.api.domain.dto.seckill.SecKillActConfDto;
import cn.com.duiba.mall.center.api.domain.dto.seckill.SecKillActConfWithSkuConfAndDataDto;
import cn.com.duiba.mall.center.api.domain.dto.seckill.SecKillActConfWithSkuConfDto;
import cn.com.duiba.mall.center.api.domain.dto.seckill.SecKillActSkuConfDto;
import cn.com.duiba.mall.center.api.domain.dto.seckill.SecKillActUserDataDto;
import cn.com.duiba.mall.center.api.domain.dto.seckill.custom.SuzhouBankSecKillResultDto;
import cn.com.duiba.mall.center.api.domain.enums.seckill.TakeSecKillChanceResultEnum;
import cn.com.duiba.mall.center.api.param.seckill.ActConfQueryListParam;
import cn.com.duiba.mall.center.api.param.seckill.ActConfQuerySelectListParam;

import java.util.List;

/**
 * cms版秒杀活动配置相关服务
 * Created by HePeng on 2019/01/14 14:27.
 */
@AdvancedFeignClient
public interface RemoteSecKillActConfService {
    /**
     * 活动列表
     * @param param
     * @return
     */
    PaginationDto<SecKillActConfWithSkuConfDto> getList(ActConfQueryListParam param);

    /**
     * 组件活动列表
     * @param appId
     * @param idList
     * @return
     */
    List<SecKillActConfWithSkuConfAndDataDto> getListForUnit(Long appId, List<Long> idList);

    /**
     * 前置接口专用活动列表
     * 没做分页，过滤掉秒杀活动结束超过15天的数据
     * @param appId
     * @return
     */
    List<SecKillActConfWithSkuConfAndDataDto> getListForFront(Long appId);

    /**
     * 苏州招行秒杀活动
     * @param appId
     * @return
     */
    SuzhouBankSecKillResultDto getResultForSuzhouBankSecKill(Long appId);

    /**
     * 活动组件中活动选择列表
     * @param param
     * @return
     */
    PaginationDto<SecKillActConfDto> getSelectList(ActConfQuerySelectListParam param);

    /**
     * 根据活动id失效活动
     * @param actId
     * @return
     */
    Boolean disableByActId(Long actId);

    /**
     * 根据活动id删除活动
     * @param actId
     * @return
     */
    Boolean deleteByActId(Long actId);

    /**
     * 根据活动id查询活动
     * @param actId
     * @return
     */
    SecKillActConfWithSkuConfDto getDetail(Long actId);

    /**
     * 根据活动id查询活动（有缓存）
     * @param actId
     * @return
     */
    SecKillActConfWithSkuConfDto getCachedDetail(Long actId);

    /**
     * 根据appItemId判断一个商品是否可用于配置活动
     * @param appItemId
     * @return true-可以
     */
    Boolean checkAppItem(Long appItemId);

    /**
     * 保存活动配置（新增或修改）
     * @param actConfWithSkuConfDto
     * @return
     */
    Long saveSecKillConf(SecKillActConfWithSkuConfDto actConfWithSkuConfDto) throws BizException;

    /************************** 提供给交易端的接口 ************************/

    /**
     * 根据商品id，获取该商品当前对应的有效的活动配置和各个sku秒杀配置及秒杀数据
     * @param appItemId
     * @return
     */
    SecKillActConfWithSkuConfAndDataDto getCachedActConfWithSkuConfAndData(Long appItemId);

    /**
     * 满赠： 根据商品id，获取该商品当前对应的有效的活动配置, 注意： 无秒杀数据和各个sku秒杀配置
     * @param appItemId
     * @return
     */
    SecKillActConfWithSkuConfAndDataDto getSimpleActConf(Long appItemId);

    /**
     * 根据活动id，获取对应的活动配置和各个sku秒杀配置及秒杀数据
     * @param actId
     * @return
     */
    SecKillActConfWithSkuConfAndDataDto getCachedActConfWithSkuConfAndDataByActId(Long actId);

    /**
     * 获取秒杀活动中用户数据
     * @param actId
     * @param consumerId
     * @return
     */
    SecKillActUserDataDto getActUserData(Long actId, Long consumerId);

    /**
     * 根据活动id和app sku id获取对应sku配置
     * @param actId
     * @param appSkuId
     * @return
     */
    SecKillActSkuConfDto getActSkuConf(Long actId, Long appSkuId);

    /**
     * 获取秒杀机会
     * @param actId
     * @param appSkuId
     * @param consumerId
     * @return
     */
    TakeSecKillChanceResultEnum takeSecKillChance(Long actId, Long appSkuId, Long consumerId);

    /**
     * 回退秒杀机会
     * @param actId
     * @param secKillMillis
     * @param appSkuId
     * @param consumerId
     * @return
     */
    void returnSecKillChance(Long actId, Long secKillMillis, Long appSkuId, Long consumerId) throws BizException;

    /**
     * 持久化活动sku秒杀数据
     */
    void persistActSkuData();

    /**
     * 手机端购物车使用
     * 根据appId查询 正在进行中活动的(秒杀开始前15min)  有效 skuId列表
     * @param appId
     * @return
     */
    List<Long> getAllEnableSkuIdsByApp(Long appId);

    /**
     * 手机端购物车使用
     * 根据appId查询 进行中或者未开始的活动 有效 skuId列表
     * @param appId
     * @return
     */
    List<Long> getUsingSkuIdsByApp(Long appId);

    /**
     * 查询有效的商品id列表
     *
     * @param appId
     * @return
     */
    List<Long> findRunAppItemIdsByAppId(Long appId);

    /**
     * @description 查询秒杀商品
     * @author liheping
     * @date 2021/7/28
     */
    List<Long> findItemIdListByAppIdAndAppItemIds(Long appId, List<Long> appItemIdList);
}
