package cn.com.duiba.mall.center.api.remoteservice.shop;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.mall.center.api.domain.dto.shop.TrolleyItemsDto;

import java.util.List;

/**
 * 购物车相关接口
 *
 * @author chengsiyi
 * @date 2018/6/27 14:03
 */
@AdvancedFeignClient
public interface RemoteTrolleyItemsService {

    /**
     * 加入购物车
     *
     * @param trolley 商品
     * @return 添加成功的ID
     */
    Long add(TrolleyItemsDto trolley);

    /**
     * 获取购物车商品列表
     *
     * @param consumerId 用户ID
     * @return 购物车商品列表
     */
    List<TrolleyItemsDto> getConsumerItems(Long consumerId);

    /**
     * 获取购物车指定商品列表
     *
     * @param consumerId 用户ID
     * @param paramList    商品IDs,如有sku，需包含sku ids
     * @return 购物车商品列表
     */
    List<TrolleyItemsDto> getItems(Long consumerId, List<TrolleyItemsDto> paramList);

    /**
     * 获取购物车商品数量（种类）
     *
     * @param consumerId 用户ID
     * @return 购物车商品种类数量
     */
    Integer getTrolleyItemCount(Long consumerId);

    /**
     * 移除购物车内的商品
     *
     * @param consumerId 用户ID
     * @param trolleyItemsDtoList 需包括商品IDs，如有sku，需包含sku ids
     * @return 移除结果
     */
    Integer removeItems(Long consumerId, List<TrolleyItemsDto> trolleyItemsDtoList);
    /**
     * 修改商品数量(支持选中操作)
     *
     * @param trolleyItems 商品信息
     * @return 修改记录
     */
    Boolean updateQuantity(List<TrolleyItemsDto> trolleyItems);

    /**
     * 开启购物车
     * 针对老版购物车
     * @param developerId 开发者id
     * @return
     */
    @Deprecated
    Boolean openShoppingCart(Long developerId);

    /**
     * 开启购物车
     * 针对新版购物车
     * @param developerId 开发者id
     * @return
     */
    Boolean openNewShoppingCart(Long developerId);

    /**
     * 开启满包邮
     * 针对新版购物车
     * @param developerId 开发者id
     * @return
     */
    Boolean freeExpressShopping(Long developerId);
}
