package cn.com.duiba.mall.center.api.domain.enums.discount;

/**
 * Created by zhangyongjie on 2021/11/17 10:39 上午
 * 优惠券使用范围
 */
public enum DiscountUseScope {
    ALL_KIND(1,"全品类"),
    SELF_ALL_KIND(2,"全品类（自有）"),
    DUIBA_ALL_KIND(3,"全品类（兑吧）"),
    SINGLE(4,"单品券");

    private int code;
    private String desc;

    DiscountUseScope(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static DiscountUseScope getByCode(Integer code){
        if(code == null){
            return null;
        }
        DiscountUseScope[] values = DiscountUseScope.values();
        for(DiscountUseScope status:values){
            if(code.intValue() == status.code){
                return status;
            }
        }
        return null;
    }

}
