package cn.com.duiba.mall.center.api.domain;

import cn.com.duiba.mall.center.api.domain.enums.ErrorCode;

/**
 * 开发者中心异常类，若异常有明确定义请指明exCode
 * Created by liuyao on 2017/2/13.
 */
public class MallCenterException extends RuntimeException{
    /**
     * 异常编码， 默认取未知异常
     */
    private String exCode = ErrorCode.MC000000.getCode();

    public MallCenterException(String message, Throwable cause) {
        super(message, cause);
    }
    public MallCenterException(String message, Throwable cause, String exCode) {
        super(message, cause);
        this.exCode = exCode;
    }

    public MallCenterException(Throwable cause) {
        super(cause);
    }

    public MallCenterException(Throwable cause, String exCode) {
        super(cause);
        this.exCode = exCode;
    }

    public MallCenterException(String message) {
        super(message);
    }

    public MallCenterException(String message, String exCode) {
        super(message);
        this.exCode = exCode;
    }

    public MallCenterException(ErrorCode code) {
        super(code.getDesc());
        this.exCode = code.getCode();
    }

    public String getExCode() {
        return exCode;
    }

    public void setExCode(String exCode) {
        this.exCode = exCode;
    }
}
