package cn.com.duiba.mall.center.api.domain.dto.shop;

import cn.com.duiba.mall.center.api.domain.enums.SelectedStatusEnum;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;

/**
 * 购物车
 * @author chengsiyi
 * @date 2018/6/25 16:08
 */
public class TrolleyItemsDto implements Serializable{

    private static final long serialVersionUID = 770126728305754535L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 用户ID
     */
    private Long consumerId;

    /**
     * 商品ID
     */
    private Long appItemId;

    /**
     * 商品sku_id
     */
    private Long skuId;

    /**
     * 支付方式
     * 原价购买：商品价格支付
     * 纯积分购买：用户自选纯积分购买
     * 纯钱购买：用户自选纯钱购买
     * @see cn.com.duiba.mall.center.api.domain.enums.TrolleyItemPaymentTypeEnum
     */
    private Integer paymentType;

    /**
     * 商品数量
     */
    private Integer quantity;

    /**
     * 选中状态 1-选中，0-未选中
     */
    private SelectedStatusEnum selected;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Integer getPaymentType() {
        return paymentType;
    }

    public void setPaymentType(Integer paymentType) {
        this.paymentType = paymentType;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public SelectedStatusEnum getSelected() {
        return selected;
    }

    public void setSelected(SelectedStatusEnum selected) {
        this.selected = selected;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
