package cn.com.duiba.mall.center.api.domain.enums.discount;

/**
 * Created by zhangyongjie on 2021/11/17 10:22 上午
 * 优惠券是否可以叠加
 */
public enum DiscountCombineSwitch {
    DISABLE(0,"不可叠加"),
    AVAILABLE(1,"可叠加");

    private int code;
    private String desc;

    DiscountCombineSwitch(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static DiscountCombineSwitch getByCode(Integer code){
        if(code == null){
            return null;
        }
        DiscountCombineSwitch[] values = DiscountCombineSwitch.values();
        for(DiscountCombineSwitch status:values){
            if(code.intValue() == status.code){
                return status;
            }
        }
        return null;
    }
}
