package cn.com.duiba.mall.center.api.domain.enums.discount;

/**
 * 权重：
 * 单品 > 叠加 >兑吧/开发者券 > 全品类券
 *
 * @author fja
 */
public enum DiscountSequenceEnum {
    /**
     * 全品类
     */
    WEIGHT_ALL_CATEGORY(1, "全品类券"),
    /***
     * 全品类-开发者
     */
    WEIGHT_DEVELOPER_EXCLUSIVE(2, "全品类-开发者券"),
    /**
     * 全品类-兑吧
     */
    WEIGHT_DUIBA_EXCLUSIVE(2, "全品类-兑吧券"),
    /**
     * 单品类
     */
    WEIGHT_SINGLE(4, "单品类券"),

    /**
     * 叠加券
     */
    WEIGHT_COMBINE(3, "叠加券"),
    ;

    private final int weight;

    private final String desc;

    DiscountSequenceEnum(int weight, String desc) {
        this.weight = weight;
        this.desc = desc;
    }

    public int getWeight() {
        return weight;
    }

    public String getDesc() {
        return desc;
    }
}
