package cn.com.duiba.mall.center.api.domain.dto.fulcredits;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
* 满赠活动配置
*/
public class FulcreditsActConfDto extends BaseFulcreditsActConfDto implements Serializable {

    private static final long serialVersionUID = -432708908435013736L;
    /**
    * 主键
    */
    private Long id;

    /**
    * 所属应用id
    */
    private Long appId;

    /**
     * 活动状态：20-失效；10-进行中；0-未开始
     */
    private Integer runStatus;

    /**
    * 有效状态：0-已失效;1-有效
    */
    private Integer enableStatus;

    /**
    * 活动名称
    */
    private String title;

    /**
    * 开始时间
    */
    private Date actStart;

    /**
    * 结束时间
    */
    private Date actEnd;

    /**
    * 模式:0-全部商品参与，1-指定商品参与
    */
    private Integer itemMode;

    /**
    * 移位运算 第0位:优惠叠加, 第1位:现金转换, 第2位:是否降级
    */
    private Integer operationsType;

    /**
    * 下单后多少天内有效
    */
    private Integer fixValidDay;

    /**
    * 固定日期时间前有效
    */
    private Date fixValidTime;

    /**
    * 活动描述
    */
    private String actDesc;

    /**
    * 用户每日兑换限制数量
    */
    private Integer perLimitCount;

    /**
    * 用户总兑换限制数量
    */
    private Integer totalLimitCount;

    /**
    * 会员限制配置
    */
    private Long vipLimits;

    /**
    * 删除标记:0-未删除，1-已删除
    */
    private Boolean deleted;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

    private List<Long> fulcreditsActItemDtoList;

    private List<FulcreditsActOptionsDto> fulcreditsActOptionsDtoList;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getAppId() {
        return appId;
    }

    public Integer getRunStatus() {
        return runStatus;
    }

    public void setRunStatus(Integer runStatus) {
        this.runStatus = runStatus;
    }

    public void setEnableStatus(Integer enableStatus) {
        this.enableStatus = enableStatus;
    }

    public Integer getEnableStatus() {
        return enableStatus;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return title;
    }

    public void setActStart(Date actStart) {
        this.actStart = actStart;
    }

    public Date getActStart() {
        return actStart;
    }

    public void setActEnd(Date actEnd) {
        this.actEnd = actEnd;
    }

    public Date getActEnd() {
        return actEnd;
    }

    public void setItemMode(Integer itemMode) {
        this.itemMode = itemMode;
    }

    public Integer getItemMode() {
        return itemMode;
    }

    public void setOperationsType(Integer operationsType) {
        this.operationsType = operationsType;
    }

    public Integer getOperationsType() {
        return operationsType;
    }

    public void setFixValidDay(Integer fixValidDay) {
        this.fixValidDay = fixValidDay;
    }

    public Integer getFixValidDay() {
        return fixValidDay;
    }

    public void setFixValidTime(Date fixValidTime) {
        this.fixValidTime = fixValidTime;
    }

    public Date getFixValidTime() {
        return fixValidTime;
    }

    public void setActDesc(String actDesc) {
        this.actDesc = actDesc;
    }

    public String getActDesc() {
        return actDesc;
    }

    public void setPerLimitCount(Integer perLimitCount) {
        this.perLimitCount = perLimitCount;
    }

    public Integer getPerLimitCount() {
        return perLimitCount;
    }

    public void setTotalLimitCount(Integer totalLimitCount) {
        this.totalLimitCount = totalLimitCount;
    }

    public Integer getTotalLimitCount() {
        return totalLimitCount;
    }

    public void setVipLimits(Long vipLimits) {
        this.vipLimits = vipLimits;
    }

    public Long getVipLimits() {
        return vipLimits;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public List<Long> getFulcreditsActItemDtoList() {
        return fulcreditsActItemDtoList;
    }

    public void setFulcreditsActItemDtoList(List<Long> fulcreditsActItemDtoList) {
        this.fulcreditsActItemDtoList = fulcreditsActItemDtoList;
    }

    public List<FulcreditsActOptionsDto> getFulcreditsActOptionsDtoList() {
        return fulcreditsActOptionsDtoList;
    }

    public void setFulcreditsActOptionsDtoList(List<FulcreditsActOptionsDto> fulcreditsActOptionsDtoList) {
        this.fulcreditsActOptionsDtoList = fulcreditsActOptionsDtoList;
    }

    /**
     * @param opType
     */
    public void grantOpTypeFulcredits(int opType) {
        int v = 1 << opType;
        this.operationsType = this.operationsType | v;
    }

    /**
     * @param opType
     */
    public void ungrantOpTypeFulcredits(int opType) {
        int v = 1 << opType;
        v = ~v;
        this.operationsType = this.operationsType & v;
    }

    /**
     * isOpTypeAppItem
     *
     * @param opType
     * @return
     */
    public boolean isOpTypeFulcredits(int opType) {
        int v = 1 << opType;
        int ret = this.operationsType & v;
        return ret != 0;
    }

    /**
     * 转换活动状态位
     * @return
     */
    public Integer changeActStatus() {
        if (this.getEnableStatus() == 0 || this.actEnd.before(new Date())) {
            return 20;
        } else if (this.getActStart().before(new Date()) && this.getActEnd().after(new Date())) {
            return 10;
        } else {
            return 0;
        }
    }
}

