package cn.com.duiba.mall.center.api.domain.dto.groupbuy;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
* 拼团活动配置表
*/
public class GroupBuyActConfDto implements Serializable {

    private static final long serialVersionUID = -7514095458464276100L;
    /**
    * 主键
    */
    private Long id;

    /**
    * appid
    */
    private Long appId;

    /**
    * 活动名称
    */
    private String actTitle;

    /**
    * 商品id
    */
    private Long appItemId;

    /**
    * sku的信息目前就拼团价和skuId{"groupBuyPrice":"","skuId":""}
    */
    private String skuInfoJson;

    private List<SkuInfo> skuInfoList;

    /**
    * 活动开始时间
    */
    private Date actStartTime;

    /**
    * 活动结束时间
    */
    private Date actEndTime;

    /**
    * 参团人数
    */
    private Integer groupPeopleNum;

    /**
    * 参团有效期  单位分
    */
    private Integer groupDuration;

    /**
    * 预告时长 单位分
    */
    private Integer foreShowDuration;

    /**
    * 限购次数
    */
    private Integer limitNum;

    /**
    * 是否展现已拼数量 0否1是
    */
    private Integer showSaleNum;

    /**
    * 基数 0正常显示 大于0代表增加基数显示，小于0代表达到该数量显示
    */
    private Integer baseNum;

    /**
    * 是否可用 0失效 1可用
    */
    private Integer enable;

    /**
    * 失效时间
    */
    private Date failureTime;

    /**
    * 是否删除 0否1是
    */
    private Integer deleted;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

    /**
     * 活动渠道
     */
    private Integer channelType;

    public Integer getChannelType() {
        return channelType;
    }

    public void setChannelType(Integer channelType) {
        this.channelType = channelType;
    }

    public List<SkuInfo> getSkuInfoList() {
        return skuInfoList;
    }

    public void setSkuInfoList(List<SkuInfo> skuInfoList) {
        this.skuInfoList = skuInfoList;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setActTitle(String actTitle) {
        this.actTitle = actTitle;
    }

    public String getActTitle() {
        return actTitle;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setSkuInfoJson(String skuInfoJson) {
        this.skuInfoJson = skuInfoJson;
    }

    public String getSkuInfoJson() {
        return skuInfoJson;
    }

    public void setActStartTime(Date actStartTime) {
        this.actStartTime = actStartTime;
    }

    public Date getActStartTime() {
        return actStartTime;
    }

    public void setActEndTime(Date actEndTime) {
        this.actEndTime = actEndTime;
    }

    public Date getActEndTime() {
        return actEndTime;
    }

    public void setGroupPeopleNum(Integer groupPeopleNum) {
        this.groupPeopleNum = groupPeopleNum;
    }

    public Integer getGroupPeopleNum() {
        return groupPeopleNum;
    }

    public void setGroupDuration(Integer groupDuration) {
        this.groupDuration = groupDuration;
    }

    public Integer getGroupDuration() {
        return groupDuration;
    }

    public Integer getForeShowDuration() {
        return foreShowDuration;
    }

    public void setForeShowDuration(Integer foreShowDuration) {
        this.foreShowDuration = foreShowDuration;
    }

    public void setLimitNum(Integer limitNum) {
        this.limitNum = limitNum;
    }

    public Integer getLimitNum() {
        return limitNum;
    }

    public void setShowSaleNum(Integer showSaleNum) {
        this.showSaleNum = showSaleNum;
    }

    public Integer getShowSaleNum() {
        return showSaleNum;
    }

    public void setBaseNum(Integer baseNum) {
        this.baseNum = baseNum;
    }

    public Integer getBaseNum() {
        return baseNum;
    }

    public void setEnable(Integer enable) {
        this.enable = enable;
    }

    public Integer getEnable() {
        return enable;
    }

    public void setFailureTime(Date failureTime) {
        this.failureTime = failureTime;
    }

    public Date getFailureTime() {
        return failureTime;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public static class SkuInfo implements Serializable {
        private static final long serialVersionUID = -405258407559260916L;

        private Long skuId;
        private Long groupBuyPrice;

        public Long getSkuId() {
            return skuId;
        }

        public void setSkuId(Long skuId) {
            this.skuId = skuId;
        }

        public Long getGroupBuyPrice() {
            return groupBuyPrice;
        }

        public void setGroupBuyPrice(Long groupBuyPrice) {
            this.groupBuyPrice = groupBuyPrice;
        }
    }
}

