package cn.com.duiba.mall.center.api.domain.enums.discount;

/**
 * Created by zhangyongjie on 2021/11/17 10:31 上午
 * 优惠券发放方式
 */
public enum DiscountDeliverType {

    GAIN(1,"领取"),
    PUSH(2,"推送");

    private int code;
    private String desc;


    DiscountDeliverType(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static DiscountDeliverType getByCode(Integer code){
        if(code == null){
            return null;
        }
        DiscountDeliverType[] values = DiscountDeliverType.values();
        for(DiscountDeliverType status:values){
            if(code.intValue() == status.code){
                return status;
            }
        }
        return null;
    }

}
