package cn.com.duiba.mall.center.api.domain.enums.discount;

/**
 * Created by zhangyongjie on 2021/11/23 2:46 下午
 * 优惠券时间维度状态
 */
public enum DiscountTimeStatus {

    NOT_START(0,"未开始"),
    PROCESSING(1,"进行中"),
    FINISHING(2,"已结束"),
    DELETED(3,"已删除");

    private int code;
    private String desc;

    DiscountTimeStatus(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static DiscountTimeStatus getByCode(Integer code){
        if(code == null){
            return null;
        }
        DiscountTimeStatus[] values = DiscountTimeStatus.values();
        for(DiscountTimeStatus status:values){
            if(code.intValue() == status.code){
                return status;
            }
        }
        return null;
    }
}
