package cn.com.duiba.mall.center.api.domain.enums.fulcredits;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by HePeng on 2019/01/21 11:30.
 */
public enum FulcreditsActRunStatusEnum {
    STATUS_INIT(0, "未开始"),
    STATUS_ING(10, "进行中"),
    STATUS_END(20, "已结束"),
    ;

    private int code;
    private String desc;

    private static Map<Integer, FulcreditsActRunStatusEnum> enumMap = Maps.newHashMap();

    static {
        for(FulcreditsActRunStatusEnum enumVal: FulcreditsActRunStatusEnum.values()) {
            enumMap.put(enumVal.getCode(), enumVal);
        }
    }

    FulcreditsActRunStatusEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static FulcreditsActRunStatusEnum getByCode(Integer code) {
        return enumMap.get(code);
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
