package cn.com.duiba.mall.center.api.remoteservice.vipgoods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.mall.center.api.domain.dto.PaginationDto;
import cn.com.duiba.mall.center.api.domain.dto.vipgoods.VipGoodsStrategyDto;
import cn.com.duiba.mall.center.api.domain.paramquary.vipgoods.StrategyPageQuery;

import java.util.List;

/**
 * 会员商品策略
 *
 * @Author: xuwei
 * @Date: 2019/05/16 15:08
 */
@AdvancedFeignClient
public interface RemoteVipGoodsStrategyService {
    /**
     * 插入
     *
     * @param record
     * @return
     */
    Long insert(VipGoodsStrategyDto record);

    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    VipGoodsStrategyDto findById(Long id);

    /**
     * 更新
     *
     * @param record
     * @return
     */
    boolean updateById(VipGoodsStrategyDto record);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    boolean deleteById(Long id);

    /**
     * 分页查询
     *
     * @param query
     * @return
     */
    PaginationDto<VipGoodsStrategyDto> find4Page(StrategyPageQuery query);

    /**
     * 根据appId查询
     *
     * @param appId
     * @return
     */
    List<VipGoodsStrategyDto> findByAppId(Long appId);

    /**
     * 根据id列表查询
     *
     * @param ids
     * @return
     */
    List<VipGoodsStrategyDto> findByIds(List<Long> ids);
}