package cn.com.duiba.message.service.api.dto;

import java.io.Serializable;
import java.util.Map;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 通知短信的请求参数体
 * Created by guoyanfei .
 * 2020/5/14 .
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class SmsNoticeParam implements Serializable {

    private static final long serialVersionUID = -4950217474083335312L;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 兑吧短信平台的签名id
     */
    private Long signId;

    /**
     * 兑吧短信平台的模板id
     */
    private Long templateId;

    /**
     * 模板中的插值的 键值对
     */
    private Map<String, String> templateParam;

    /**
     * 需要获取结果通知的消息
     * 默认不需要
     */
    private boolean needResultNotice = false;

}
