package cn.com.duiba.message.service.api.dto;

/**
 * 短信发送响应状态码枚举
 * 暂时预留，后续可能会有新的异常情况需要通过枚举来区分。目前为止所有的异常情况，只需要BizException就可以了
 * Created by guoyanfei .
 * 2020/5/14 .
 */
public enum SmsReturnCode {

    CODE_0(0, "成功");

    SmsReturnCode(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private final int code;

    private final String desc;

    public int code() {
        return code;
    }

    public String desc() {
        return desc;
    }

    public static SmsReturnCode get(int code) {
        for (SmsReturnCode item : SmsReturnCode.values()) {
            if (item.code() == code) {
                return item;
            }
        }
        throw new RuntimeException("invalid enum value!");
    }
}
