package cn.com.duiba.message.service.api.enums;

/**
 * 短信通道状态
 */
public enum BizLineStatusEnum {

    INVALID(0, "禁用"),
    VALID(1, "启用");

    private final int value;

    private final String desc;

    BizLineStatusEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String desc() {
        return desc;
    }

    public int value() {
        return value;
    }

    public static BizLineStatusEnum get(int value) {
        for (BizLineStatusEnum item : BizLineStatusEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        throw new RuntimeException("invalid enum value!");
    }
}
