package cn.com.duiba.message.service.api.enums;

/**
 * 短信通道状态
 */
public enum SmsChannelStatusEnum {

    INVALID(0, "禁用"),
    VALID(1, "启用");

    private final int value;

    private final String desc;

    SmsChannelStatusEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String desc() {
        return desc;
    }

    public int value() {
        return value;
    }

    public static SmsChannelStatusEnum get(int value) {
        for (SmsChannelStatusEnum item : SmsChannelStatusEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        throw new RuntimeException("invalid enum value!");
    }
}
