package cn.com.duiba.message.service.api.enums;

/**
 * Created by guoyanfei .
 * 2020/5/29 .
 */
public enum SmsNoticeCode {

    SUCCESS(0, "成功"),
    NULL_NUM(1, "空号"),
    MOBILE_STOP_CLOSE(2, "停机/关机"),
    NUM_INVALID(3, "非法/无效号码"),
    BLACK_LIST(4, "黑名单"),
    OTHERS(5, "其他");

    SmsNoticeCode(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    private final int value;

    private final String desc;

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static SmsNoticeCode get(int value) {
        for (SmsNoticeCode item : SmsNoticeCode.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        throw new RuntimeException("invalid enum value!");
    }
}
