package cn.com.duiba.message.service.api.enums;

/**
 * 短信服务类型, 枚举为位运算的位数
 */
public enum SmsServiceTypeBitEnum {

    VERIFICATION_CODE(0, "验证码类"),
    NOTICE(1, "通知类");

    private final int value;

    private final String desc;

    SmsServiceTypeBitEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String desc() {
        return desc;
    }

    public int value() {
        return value;
    }

    public static SmsServiceTypeBitEnum get(int value) {
        for (SmsServiceTypeBitEnum item : SmsServiceTypeBitEnum.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        throw new RuntimeException("invalid enum value!");
    }
}
