package cn.com.duiba.message.service.api.param;

import java.io.Serializable;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.builder.ToStringBuilder;

@Data
@NoArgsConstructor
public class MonternetReceiveParam implements Serializable {

    private static final long serialVersionUID = 7887237537326931405L;

    /**
     * 用户Id
     */
    private String userid;

    /**
     * 密码
     */
    private String pwd;

    /**
     * 时间戳 MMDDHHMMSS
     */
    private String timestamp;

    /**
     * 推送上行请求命令
     */
    private String cmd;

    /**
     * 请求消息流水号
     */
    private String seqid;

    /**
     * 上行信息 {@link Rpt}
     */
    private String rpts;

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("userid", userid).append("pwd", pwd).append("timestamp", timestamp).append("cmd", cmd).append("seqid", seqid).append("rpts", rpts).toString();
    }
}
