package cn.com.duiba.message.service.api.param;

import java.io.Serializable;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class MoternetResponse implements Serializable {

    private static final long serialVersionUID = 501082085837389222L;

    /**
     * 成功
     */
    private static final Integer SUCCESS_RESULT = 0;

    /**
     * 失败
     */
    private static final Integer FAIL_RESULT = -1;

    /**
     * 必须填RPT_RESP
     */
    private String cmd = "RPT_RESP";

    /**
     * 与请求中的seqid保持一致
     */
    private String seqid;

    /**
     * 返回结果 0-成功 非0-失败
     */
    private Integer result;

    public static MoternetResponse success(String seqid) {
        MoternetResponse response = new MoternetResponse();
        response.setSeqid(seqid);
        response.setResult(SUCCESS_RESULT);
        return response;
    }

    public static MoternetResponse fail(String seqid) {
        MoternetResponse response = new MoternetResponse();
        response.setSeqid(seqid);
        response.setResult(FAIL_RESULT);
        return response;
    }

    public MoternetResponse(String seqid) {
        this.seqid = seqid;
    }

}
