package cn.com.duiba.message.service.api.param;

import lombok.Data;

import java.io.Serializable;

@Data
public class SmsNjxhSubParam implements Serializable {
    private static final long serialVersionUID = -5793540973510279167L;
    /**
     * 唯一短信标识，有融合通信平台生成(32位)
     */
    private String smsId;

    /**
     * 应用Id
     */
    private String appId;

    /**
     *手机号码 (接收短信的手机号码)
     */
    private String mobile;

    /**
     * 该条短信在您业务系统内的ID，如订单号或者短信发送记录流水号(客户数据，融合通信平台透传，最长64字节)
     */
    private String userData;

    /**
     * 发送状态 (0:成功;1:失败)
     */
    private String state;

    /**
     * 发送状态描述
     */
    private String desc;

    /**
     * 发送状态描述(中文)
     */
    private String descChs;

    /**
     * 接收时间，客户接收到短信的时间
     * (如：2017-01-23 12:25:23)
     */
    private String receiveTime;

    /**
     * 费用(单位：元)
     */
    private String fee;

    /**
     * 通道返回的客户实际接收到短信的时间“减去”平台收到客户提交的短信时间(单位：秒)
     */
    private String sendDuration;


}
